/* ====================================================================
 * Copyright (c) 1999-2006 Carnegie Mellon University.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * This work was supported in part by funding from the Defense Advanced 
 * Research Projects Agency and the National Science Foundation of the 
 * United States of America, and the CMU Sphinx Speech Consortium.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND 
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY
 * NOR ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 *
 */


#include <math.h>
#include <stdio.h>

 /*
  * PWP: coding change.  Numbers were previously coded base-3.
  * Now base-4, since (int) pow(4,i) == 1 << (2*i)
  */
void decode_bo_case(int bo_case,
                    int context_length,
                    FILE *annotation_fp);

void decode_bo_case(int bo_case,
		    int context_length,
		    FILE *annotation_fp) {
   

  int i;
  int current_bo_case;
  
  for(i=context_length-1;i>=0;i--) {

    fprintf(annotation_fp,"%d",i+2);

    current_bo_case = bo_case / (1 << (2*i));

    if (current_bo_case == 1) {
      fprintf(annotation_fp,"-");
    }
    else {
      if (current_bo_case == 2) {
	fprintf(annotation_fp,"x");
      }
      else {
	i=-2;
      }
    }
    bo_case -= (current_bo_case * (1 << (2*i)));

  }

  if (i>-2) {
    fprintf(annotation_fp,"1");
  }

  fprintf(annotation_fp,"\n");

}
