/* ====================================================================
 * Copyright (c) 1999-2006 Carnegie Mellon University.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * This work was supported in part by funding from the Defense Advanced 
 * Research Projects Agency and the National Science Foundation of the 
 * United States of America, and the CMU Sphinx Speech Consortium.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND 
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY
 * NOR ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 *
 */


/* Fill array with pointer to arguments (in the same format as argv),
   and store the number of arguments (like argc) */

#include <string.h>
#include <stdio.h>
#include "general.h"   // from libs

void parse_comline(char *input_line,
                   int *num_of_args,
                   char **args);

void parse_comline(char *input_line,
		   int *num_of_args,
		   char **args) {

  size_t next_space;
  char next_word[200];

  *num_of_args = 0;

  while (strlen(input_line) > 0) {
    
    if (input_line[0] == ' ') {
      input_line = &(input_line[1]);
    }
    else {
      next_space = strcspn(input_line," ");

      if (input_line[next_space]==' ') {
	strncpy(next_word,input_line,next_space);
	next_word[next_space] = '\0';
	input_line = &(input_line[next_space+1]);
      }
      else {
	strcpy(next_word,input_line);
	input_line[0]='\0';
      }

      args[*num_of_args] = rr_salloc(next_word);

      (*num_of_args)++;
      
    }
  }
  
}
